#ifndef ClientThread_Cpp
#define ClientThread_Cpp
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define WIN32_LEAN_AND_MEAN

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WinSock2.H>
#include <WinSock.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "CSockSrvr.H"

#include "../../SharedSource/NSWFL.H"

#include "../Source/Entry.H"
#include "../Source/Routines.H"
#include "../Source/HandShake.H"
#include "../Source/Command.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HANDLE ghEvent_ClientThread = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CSockSrvr::Start_ClientThread(int iClient)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> CSockSrvr::Start_ClientThread.\n");
    #endif

	ghEvent_ClientThread = CreateEvent(NULL, TRUE, FALSE, "Client_Thread_Function");

	memset(&CTI, 0, sizeof(CTI));
    CTI.Client = iClient;

    if((hcClient_Thread_Handle[iClient] = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)Client_Thread_Function, (LPVOID) this, 0, (LPDWORD) &dwcClient_Thread_ID[iClient])) == NULL)
    {
        FatalError(__FILE__, __LINE__, "CreateThread failed.");
        CloseHandle(ghEvent_ClientThread);
        return false;
    }

    if(WaitForSingleObject(ghEvent_ClientThread, 5000) == WAIT_TIMEOUT)
    {
        CloseHandle(ghEvent_ClientThread);
        return false;
    }

	//The thread was started, trigger the event.
	Events.OnBeginClientThread(this, iClient);

	CloseHandle(ghEvent_ClientThread);
    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CSockSrvr::WaitOnClientThreadToExit(int iClient)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> CSockSrvr::WaitOnClientThreadToExit.\n");
    #endif

    DWORD dwExitCode = 0;

    int iWaitCount = 0;

    while(GetExitCodeThread(hcClient_Thread_Handle[iClient], &dwExitCode))
    {
        if(dwExitCode != STILL_ACTIVE || iWaitCount == 500)
        {
            if(iWaitCount == 500)
            {
                printf("Possible thread dead-lock. Client[%d]'s thread will be terminated.\n", iClient);
                TerminateThread(hcClient_Thread_Handle[iClient], 1);
            }

            //The thread was stopped, trigger the event.
			Events.OnEndClientThread(this, iClient);

			CloseHandle(hcClient_Thread_Handle[iClient]);
            dwcClient_Thread_ID[iClient] = 0;
            return true;
        }

        iWaitCount++;
        Sleep(1);
    }

	//The thread was stopped, trigger the event.
	Events.OnEndClientThread(this, iClient);

    FatalError(__FILE__, __LINE__, "GetExitCodeThread failed.");
    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI Client_Thread_Function(LPVOID pvThread)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> Client_Thread_Function.\n");
    #endif

    //---------------------(Initialize Thread [Begin])----------
   	CSockSrvr *pSockSrvr = ((CSockSrvr *)pvThread);

	int iClient = ((CSockSrvr *)pvThread)->CTI.Client;

	SetEvent(ghEvent_ClientThread);
    //---------------------(Initialize Thread [END])----------

    char sRecvBuf[IDEAL_RECV_SIZE + 1];
    char sRawHash[1024];
	int iRecvBufSz = 0;
	int iWait = 0;

	//--------------------------------------------------------------------------------------------------------
	/*(This BELOW helps to point out Denial-of-Service attacks) (BEGIN) */
	if(!GenerateKey(giRawHashLen, (GetTickCount()+iClient), GKUPPER_AZ|GKLOWER_AZ|GKNUMBERS|GKNONREPETITION, sRawHash))
	{
		WriteLog(pSockSrvr->icClientID[iClient], "Client_Thread_Function failed to generate a key.");
		pSockSrvr->bcDisconnect[iClient] = true;
		return 0;
	}

	//Using the sRecvBuf and iRecvBufSz to hold the data to be sent.
	//This is not standard, Just saving stack space.
	iRecvBufSz = AppendDataToCmd("::RawHash->", sRawHash, giRawHashLen, sRecvBuf);
	pSockSrvr->SetNextSendDataEx(iClient, sRecvBuf, iRecvBufSz);

	CipherKey(sRawHash, sRawHash, giRawHashLen);

	while(pSockSrvr->bcConnected[iClient] && !pSockSrvr->bcDisconnect[iClient])
    {
	    if(pSockSrvr->GetClientData(iClient, sRecvBuf, &iRecvBufSz))
	    {
			sRawHash[giRawHashLen] = '\0';
			sRecvBuf[iRecvBufSz] = '\0';

			if(strcmp(sRawHash, sRecvBuf) != 0)
			{
				WriteLog(pSockSrvr->icClientID[iClient], "WARNING: Client returned incorrect hash value. Possible DOS attack.");
				pSockSrvr->bcDisconnect[iClient] = true;
				giWarningCount++;
				return 0;
			}
			break;
		}

		iWait++;

		if(iWait == giHashTimeoutMS)
		{
			WriteLog(pSockSrvr->icClientID[iClient], "WARNING: Client did not respond. Possible DOS attack.");
			pSockSrvr->bcDisconnect[iClient] = true;
			giWarningCount++;
			return 0;				
		}

		Sleep(1);
	}
	/*(The ABOVE code helps to point out Denial-of-Service attacks) (END) */
	//--------------------------------------------------------------------------------------------------------

	pSockSrvr->SetNextSendData(iClient, "::RequestAuthString");

	while(pSockSrvr->bcConnected[iClient] && !pSockSrvr->bcDisconnect[iClient])
    {
        if(pSockSrvr->GetClientData(iClient, sRecvBuf, &iRecvBufSz))
        {
			//sRecvBuf[iRecvBufSz] = '\0';
			//printf("GotSize[%d] : %d\n", iClient, iRecvBufSz);
			//printf("GotData[%d]:%s\n", iClient, sRecvBuf);

			if(CCI[iClient].bIsAuthenticated == false)
			{
				int iAuthResult = PerformHandShake(pSockSrvr, iClient, sRecvBuf, iRecvBufSz);
				if(iAuthResult == AUTH_FAILED || iAuthResult == AUTH_ERROR)
				{
					WriteLog(pSockSrvr->icClientID[iClient], "WARNING: Authentication failed.");
					giWarningCount++;
					pSockSrvr->bcDisconnect[iClient] = true;
					return 0;
				}
				else if(iAuthResult == AUTH_SUCCESS){

					CCI[iClient].bIsAuthenticated = true;

					if(gbUseCompression)
						strcpy(sRecvBuf, "::Compression->On");
					else strcpy(sRecvBuf, "::Compression->Off");
					pSockSrvr->SetNextSendData(iClient, sRecvBuf);

					if(CCI[iClient].bRequestInit)
					{
						pSockSrvr->SetNextSendData(iClient, "::BeginInit");
					}
					else{
						pSockSrvr->SetNextSendData(iClient, "::BeginReplication->Transactions");
					}
				}
				else if(iAuthResult == AUTH_OK){
					//The authentication process is still in process, all is well.
				}
			}
			else{
				int iCmdResult = ProcessCommand(pSockSrvr, iClient, sRecvBuf, iRecvBufSz);
				if(iCmdResult == CMD_ERROR)
				{
					giWarningCount++;
					WriteLog(pSockSrvr->icClientID[iClient], "WARNING: Process command returned with an error.");
					pSockSrvr->bcDisconnect[iClient] = true;
					return 0;
				}
				else if(iCmdResult == CMD_DONE) {
					pSockSrvr->bcDisconnect[iClient] = true;
					return 0;
				}
				else if(iCmdResult == CMD_OK) {
					//All is well.
				}
			}
		}
        else Sleep(CLIENTTHREAD_MS_WAIT);
    }

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

